package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationEndpointPrometheusUserConfig private(
  basicAuthPassword: Option[String],
  basicAuthUsername: Option[String]
) derives Decoder

object GetServiceIntegrationEndpointPrometheusUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationEndpointPrometheusUserConfig])
      def basicAuthPassword: Output[Option[String]] = output.map(_.basicAuthPassword)
      def basicAuthUsername: Output[Option[String]] = output.map(_.basicAuthUsername)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationEndpointPrometheusUserConfig]])
      def basicAuthPassword: Output[Option[String]] = output.map(_.flatMap(_.basicAuthPassword))
      def basicAuthUsername: Output[Option[String]] = output.map(_.flatMap(_.basicAuthUsername))


