package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationEndpointRsyslogUserConfig private(
  ca: Option[String],
  cert: Option[String],
  format: String,
  key: Option[String],
  logline: Option[String],
  port: Int,
  sd: Option[String],
  server: String,
  tls: Boolean
) derives Decoder

object GetServiceIntegrationEndpointRsyslogUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationEndpointRsyslogUserConfig])
      def ca: Output[Option[String]] = output.map(_.ca)
      def cert: Output[Option[String]] = output.map(_.cert)
      def format: Output[String] = output.map(_.format)
      def key: Output[Option[String]] = output.map(_.key)
      def logline: Output[Option[String]] = output.map(_.logline)
      def port: Output[Int] = output.map(_.port)
      def sd: Output[Option[String]] = output.map(_.sd)
      def server: Output[String] = output.map(_.server)
      def tls: Output[Boolean] = output.map(_.tls)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationEndpointRsyslogUserConfig]])
      def ca: Output[Option[String]] = output.map(_.flatMap(_.ca))
      def cert: Output[Option[String]] = output.map(_.flatMap(_.cert))
      def format: Output[Option[String]] = output.map(_.map(_.format))
      def key: Output[Option[String]] = output.map(_.flatMap(_.key))
      def logline: Output[Option[String]] = output.map(_.flatMap(_.logline))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def sd: Output[Option[String]] = output.map(_.flatMap(_.sd))
      def server: Output[Option[String]] = output.map(_.map(_.server))
      def tls: Output[Option[Boolean]] = output.map(_.map(_.tls))


