package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationKafkaLogsUserConfig private(
  kafkaTopic: String,
  selectedLogFields: Option[scala.collection.immutable.List[String]]
) derives Decoder

object GetServiceIntegrationKafkaLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationKafkaLogsUserConfig])
      def kafkaTopic: Output[String] = output.map(_.kafkaTopic)
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.selectedLogFields)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationKafkaLogsUserConfig]])
      def kafkaTopic: Output[Option[String]] = output.map(_.map(_.kafkaTopic))
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.selectedLogFields))


