package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationLogsUserConfig private(
  elasticsearchIndexDaysMax: Option[Int],
  elasticsearchIndexPrefix: Option[String],
  selectedLogFields: Option[scala.collection.immutable.List[String]]
) derives Decoder

object GetServiceIntegrationLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationLogsUserConfig])
      def elasticsearchIndexDaysMax: Output[Option[Int]] = output.map(_.elasticsearchIndexDaysMax)
      def elasticsearchIndexPrefix: Output[Option[String]] = output.map(_.elasticsearchIndexPrefix)
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.selectedLogFields)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationLogsUserConfig]])
      def elasticsearchIndexDaysMax: Output[Option[Int]] = output.map(_.flatMap(_.elasticsearchIndexDaysMax))
      def elasticsearchIndexPrefix: Output[Option[String]] = output.map(_.flatMap(_.elasticsearchIndexPrefix))
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.selectedLogFields))


