package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationMetricsUserConfig private(
  database: Option[String],
  retentionDays: Option[Int],
  roUsername: Option[String],
  sourceMysql: Option[besom.api.aiven.outputs.GetServiceIntegrationMetricsUserConfigSourceMysql],
  username: Option[String]
) derives Decoder

object GetServiceIntegrationMetricsUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationMetricsUserConfig])
      def database: Output[Option[String]] = output.map(_.database)
      def retentionDays: Output[Option[Int]] = output.map(_.retentionDays)
      def roUsername: Output[Option[String]] = output.map(_.roUsername)
      def sourceMysql: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationMetricsUserConfigSourceMysql]] = output.map(_.sourceMysql)
      def username: Output[Option[String]] = output.map(_.username)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationMetricsUserConfig]])
      def database: Output[Option[String]] = output.map(_.flatMap(_.database))
      def retentionDays: Output[Option[Int]] = output.map(_.flatMap(_.retentionDays))
      def roUsername: Output[Option[String]] = output.map(_.flatMap(_.roUsername))
      def sourceMysql: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationMetricsUserConfigSourceMysql]] = output.map(_.flatMap(_.sourceMysql))
      def username: Output[Option[String]] = output.map(_.flatMap(_.username))


