package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GrafanaGrafanaUserConfigAuthGithub private(
  allowSignUp: Option[Boolean],
  allowedOrganizations: Option[scala.collection.immutable.List[String]],
  clientId: String,
  clientSecret: String,
  teamIds: Option[scala.collection.immutable.List[Int]]
) derives Decoder

object GrafanaGrafanaUserConfigAuthGithub:
  given outputOps: {} with
    extension(output: Output[GrafanaGrafanaUserConfigAuthGithub])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.allowSignUp)
      def allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedOrganizations)
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def teamIds: Output[Option[scala.collection.immutable.List[Int]]] = output.map(_.teamIds)

  given optionOutputOps: {} with
    extension(output: Output[Option[GrafanaGrafanaUserConfigAuthGithub]])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.flatMap(_.allowSignUp))
      def allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedOrganizations))
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def teamIds: Output[Option[scala.collection.immutable.List[Int]]] = output.map(_.flatMap(_.teamIds))


