package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GrafanaGrafanaUserConfigAuthGoogle private(
  allowSignUp: Option[Boolean],
  allowedDomains: Option[scala.collection.immutable.List[String]],
  clientId: String,
  clientSecret: String
) derives Decoder

object GrafanaGrafanaUserConfigAuthGoogle:
  given outputOps: {} with
    extension(output: Output[GrafanaGrafanaUserConfigAuthGoogle])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.allowSignUp)
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedDomains)
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)

  given optionOutputOps: {} with
    extension(output: Output[Option[GrafanaGrafanaUserConfigAuthGoogle]])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.flatMap(_.allowSignUp))
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedDomains))
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))


