package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GrafanaGrafanaUserConfigExternalImageStorage private(
  accessKey: String,
  bucketUrl: String,
  provider: String,
  secretKey: String
) derives Decoder

object GrafanaGrafanaUserConfigExternalImageStorage:
  given outputOps: {} with
    extension(output: Output[GrafanaGrafanaUserConfigExternalImageStorage])
      def accessKey: Output[String] = output.map(_.accessKey)
      def bucketUrl: Output[String] = output.map(_.bucketUrl)
      def provider: Output[String] = output.map(_.provider)
      def secretKey: Output[String] = output.map(_.secretKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[GrafanaGrafanaUserConfigExternalImageStorage]])
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def bucketUrl: Output[Option[String]] = output.map(_.map(_.bucketUrl))
      def provider: Output[Option[String]] = output.map(_.map(_.provider))
      def secretKey: Output[Option[String]] = output.map(_.map(_.secretKey))


