package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class InfluxDbInfluxdbUserConfig private(
  additionalBackupRegions: Option[String],
  customDomain: Option[String],
  influxdb: Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigInfluxdb],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  privateAccess: Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivateAccess],
  privatelinkAccess: Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivatelinkAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPublicAccess],
  recoveryBasebackupName: Option[String],
  serviceToForkFrom: Option[String],
  staticIps: Option[Boolean]
) derives Decoder

object InfluxDbInfluxdbUserConfig:
  given outputOps: {} with
    extension(output: Output[InfluxDbInfluxdbUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def customDomain: Output[Option[String]] = output.map(_.customDomain)
      def influxdb: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigInfluxdb]] = output.map(_.influxdb)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def privateAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPublicAccess]] = output.map(_.publicAccess)
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.recoveryBasebackupName)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[InfluxDbInfluxdbUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def customDomain: Output[Option[String]] = output.map(_.flatMap(_.customDomain))
      def influxdb: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigInfluxdb]] = output.map(_.flatMap(_.influxdb))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def privateAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.InfluxDbInfluxdbUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.flatMap(_.recoveryBasebackupName))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


