package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class InfluxDbInfluxdbUserConfigInfluxdb private(
  logQueriesAfter: Option[Int],
  maxConnectionLimit: Option[Int],
  maxRowLimit: Option[Int],
  maxSelectBuckets: Option[Int],
  maxSelectPoint: Option[Int],
  queryLogEnabled: Option[Boolean],
  queryTimeout: Option[Int]
) derives Decoder

object InfluxDbInfluxdbUserConfigInfluxdb:
  given outputOps: {} with
    extension(output: Output[InfluxDbInfluxdbUserConfigInfluxdb])
      def logQueriesAfter: Output[Option[Int]] = output.map(_.logQueriesAfter)
      def maxConnectionLimit: Output[Option[Int]] = output.map(_.maxConnectionLimit)
      def maxRowLimit: Output[Option[Int]] = output.map(_.maxRowLimit)
      def maxSelectBuckets: Output[Option[Int]] = output.map(_.maxSelectBuckets)
      def maxSelectPoint: Output[Option[Int]] = output.map(_.maxSelectPoint)
      def queryLogEnabled: Output[Option[Boolean]] = output.map(_.queryLogEnabled)
      def queryTimeout: Output[Option[Int]] = output.map(_.queryTimeout)

  given optionOutputOps: {} with
    extension(output: Output[Option[InfluxDbInfluxdbUserConfigInfluxdb]])
      def logQueriesAfter: Output[Option[Int]] = output.map(_.flatMap(_.logQueriesAfter))
      def maxConnectionLimit: Output[Option[Int]] = output.map(_.flatMap(_.maxConnectionLimit))
      def maxRowLimit: Output[Option[Int]] = output.map(_.flatMap(_.maxRowLimit))
      def maxSelectBuckets: Output[Option[Int]] = output.map(_.flatMap(_.maxSelectBuckets))
      def maxSelectPoint: Output[Option[Int]] = output.map(_.flatMap(_.maxSelectPoint))
      def queryLogEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.queryLogEnabled))
      def queryTimeout: Output[Option[Int]] = output.map(_.flatMap(_.queryTimeout))


