package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaConnectorTask private(
  connector: Option[String],
  task: Option[Int]
) derives Decoder

object KafkaConnectorTask:
  given outputOps: {} with
    extension(output: Output[KafkaConnectorTask])
      def connector: Output[Option[String]] = output.map(_.connector)
      def task: Output[Option[Int]] = output.map(_.task)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaConnectorTask]])
      def connector: Output[Option[String]] = output.map(_.flatMap(_.connector))
      def task: Output[Option[Int]] = output.map(_.flatMap(_.task))


