package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafka private(
  accessCert: Option[String],
  accessKey: Option[String],
  connectUri: Option[String],
  restUri: Option[String],
  schemaRegistryUri: Option[String]
) derives Decoder

object KafkaKafka:
  given outputOps: {} with
    extension(output: Output[KafkaKafka])
      def accessCert: Output[Option[String]] = output.map(_.accessCert)
      def accessKey: Output[Option[String]] = output.map(_.accessKey)
      def connectUri: Output[Option[String]] = output.map(_.connectUri)
      def restUri: Output[Option[String]] = output.map(_.restUri)
      def schemaRegistryUri: Output[Option[String]] = output.map(_.schemaRegistryUri)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafka]])
      def accessCert: Output[Option[String]] = output.map(_.flatMap(_.accessCert))
      def accessKey: Output[Option[String]] = output.map(_.flatMap(_.accessKey))
      def connectUri: Output[Option[String]] = output.map(_.flatMap(_.connectUri))
      def restUri: Output[Option[String]] = output.map(_.flatMap(_.restUri))
      def schemaRegistryUri: Output[Option[String]] = output.map(_.flatMap(_.schemaRegistryUri))


