package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafkaUserConfig private(
  additionalBackupRegions: Option[String],
  customDomain: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaKafkaUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  kafka: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafka],
  kafkaAuthenticationMethods: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaAuthenticationMethods],
  kafkaConnect: Option[Boolean],
  kafkaConnectConfig: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaConnectConfig],
  kafkaRest: Option[Boolean],
  kafkaRestAuthorization: Option[Boolean],
  kafkaRestConfig: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaRestConfig],
  kafkaVersion: Option[String],
  privateAccess: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivateAccess],
  privatelinkAccess: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivatelinkAccess],
  publicAccess: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPublicAccess],
  schemaRegistry: Option[Boolean],
  schemaRegistryConfig: Option[besom.api.aiven.outputs.KafkaKafkaUserConfigSchemaRegistryConfig],
  staticIps: Option[Boolean]
) derives Decoder

object KafkaKafkaUserConfig:
  given outputOps: {} with
    extension(output: Output[KafkaKafkaUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def customDomain: Output[Option[String]] = output.map(_.customDomain)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaKafkaUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def kafka: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafka]] = output.map(_.kafka)
      def kafkaAuthenticationMethods: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaAuthenticationMethods]] = output.map(_.kafkaAuthenticationMethods)
      def kafkaConnect: Output[Option[Boolean]] = output.map(_.kafkaConnect)
      def kafkaConnectConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaConnectConfig]] = output.map(_.kafkaConnectConfig)
      def kafkaRest: Output[Option[Boolean]] = output.map(_.kafkaRest)
      def kafkaRestAuthorization: Output[Option[Boolean]] = output.map(_.kafkaRestAuthorization)
      def kafkaRestConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaRestConfig]] = output.map(_.kafkaRestConfig)
      def kafkaVersion: Output[Option[String]] = output.map(_.kafkaVersion)
      def privateAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)
      def publicAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPublicAccess]] = output.map(_.publicAccess)
      def schemaRegistry: Output[Option[Boolean]] = output.map(_.schemaRegistry)
      def schemaRegistryConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigSchemaRegistryConfig]] = output.map(_.schemaRegistryConfig)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafkaUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def customDomain: Output[Option[String]] = output.map(_.flatMap(_.customDomain))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaKafkaUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def kafka: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafka]] = output.map(_.flatMap(_.kafka))
      def kafkaAuthenticationMethods: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaAuthenticationMethods]] = output.map(_.flatMap(_.kafkaAuthenticationMethods))
      def kafkaConnect: Output[Option[Boolean]] = output.map(_.flatMap(_.kafkaConnect))
      def kafkaConnectConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaConnectConfig]] = output.map(_.flatMap(_.kafkaConnectConfig))
      def kafkaRest: Output[Option[Boolean]] = output.map(_.flatMap(_.kafkaRest))
      def kafkaRestAuthorization: Output[Option[Boolean]] = output.map(_.flatMap(_.kafkaRestAuthorization))
      def kafkaRestConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigKafkaRestConfig]] = output.map(_.flatMap(_.kafkaRestConfig))
      def kafkaVersion: Output[Option[String]] = output.map(_.flatMap(_.kafkaVersion))
      def privateAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))
      def publicAccess: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def schemaRegistry: Output[Option[Boolean]] = output.map(_.flatMap(_.schemaRegistry))
      def schemaRegistryConfig: Output[Option[besom.api.aiven.outputs.KafkaKafkaUserConfigSchemaRegistryConfig]] = output.map(_.flatMap(_.schemaRegistryConfig))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


