package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafkaUserConfigKafka private(
  autoCreateTopicsEnable: Option[Boolean],
  compressionType: Option[String],
  connectionsMaxIdleMs: Option[Int],
  defaultReplicationFactor: Option[Int],
  groupInitialRebalanceDelayMs: Option[Int],
  groupMaxSessionTimeoutMs: Option[Int],
  groupMinSessionTimeoutMs: Option[Int],
  logCleanerDeleteRetentionMs: Option[Int],
  logCleanerMaxCompactionLagMs: Option[Int],
  logCleanerMinCleanableRatio: Option[Double],
  logCleanerMinCompactionLagMs: Option[Int],
  logCleanupPolicy: Option[String],
  logFlushIntervalMessages: Option[Int],
  logFlushIntervalMs: Option[Int],
  logIndexIntervalBytes: Option[Int],
  logIndexSizeMaxBytes: Option[Int],
  logMessageDownconversionEnable: Option[Boolean],
  logMessageTimestampDifferenceMaxMs: Option[Int],
  logMessageTimestampType: Option[String],
  logPreallocate: Option[Boolean],
  logRetentionBytes: Option[Int],
  logRetentionHours: Option[Int],
  logRetentionMs: Option[Int],
  logRollJitterMs: Option[Int],
  logRollMs: Option[Int],
  logSegmentBytes: Option[Int],
  logSegmentDeleteDelayMs: Option[Int],
  maxConnectionsPerIp: Option[Int],
  maxIncrementalFetchSessionCacheSlots: Option[Int],
  messageMaxBytes: Option[Int],
  minInsyncReplicas: Option[Int],
  numPartitions: Option[Int],
  offsetsRetentionMinutes: Option[Int],
  producerPurgatoryPurgeIntervalRequests: Option[Int],
  replicaFetchMaxBytes: Option[Int],
  replicaFetchResponseMaxBytes: Option[Int],
  socketRequestMaxBytes: Option[Int],
  transactionRemoveExpiredTransactionCleanupIntervalMs: Option[Int],
  transactionStateLogSegmentBytes: Option[Int]
) derives Decoder

object KafkaKafkaUserConfigKafka:
  given outputOps: {} with
    extension(output: Output[KafkaKafkaUserConfigKafka])
      def autoCreateTopicsEnable: Output[Option[Boolean]] = output.map(_.autoCreateTopicsEnable)
      def compressionType: Output[Option[String]] = output.map(_.compressionType)
      def connectionsMaxIdleMs: Output[Option[Int]] = output.map(_.connectionsMaxIdleMs)
      def defaultReplicationFactor: Output[Option[Int]] = output.map(_.defaultReplicationFactor)
      def groupInitialRebalanceDelayMs: Output[Option[Int]] = output.map(_.groupInitialRebalanceDelayMs)
      def groupMaxSessionTimeoutMs: Output[Option[Int]] = output.map(_.groupMaxSessionTimeoutMs)
      def groupMinSessionTimeoutMs: Output[Option[Int]] = output.map(_.groupMinSessionTimeoutMs)
      def logCleanerDeleteRetentionMs: Output[Option[Int]] = output.map(_.logCleanerDeleteRetentionMs)
      def logCleanerMaxCompactionLagMs: Output[Option[Int]] = output.map(_.logCleanerMaxCompactionLagMs)
      def logCleanerMinCleanableRatio: Output[Option[Double]] = output.map(_.logCleanerMinCleanableRatio)
      def logCleanerMinCompactionLagMs: Output[Option[Int]] = output.map(_.logCleanerMinCompactionLagMs)
      def logCleanupPolicy: Output[Option[String]] = output.map(_.logCleanupPolicy)
      def logFlushIntervalMessages: Output[Option[Int]] = output.map(_.logFlushIntervalMessages)
      def logFlushIntervalMs: Output[Option[Int]] = output.map(_.logFlushIntervalMs)
      def logIndexIntervalBytes: Output[Option[Int]] = output.map(_.logIndexIntervalBytes)
      def logIndexSizeMaxBytes: Output[Option[Int]] = output.map(_.logIndexSizeMaxBytes)
      def logMessageDownconversionEnable: Output[Option[Boolean]] = output.map(_.logMessageDownconversionEnable)
      def logMessageTimestampDifferenceMaxMs: Output[Option[Int]] = output.map(_.logMessageTimestampDifferenceMaxMs)
      def logMessageTimestampType: Output[Option[String]] = output.map(_.logMessageTimestampType)
      def logPreallocate: Output[Option[Boolean]] = output.map(_.logPreallocate)
      def logRetentionBytes: Output[Option[Int]] = output.map(_.logRetentionBytes)
      def logRetentionHours: Output[Option[Int]] = output.map(_.logRetentionHours)
      def logRetentionMs: Output[Option[Int]] = output.map(_.logRetentionMs)
      def logRollJitterMs: Output[Option[Int]] = output.map(_.logRollJitterMs)
      def logRollMs: Output[Option[Int]] = output.map(_.logRollMs)
      def logSegmentBytes: Output[Option[Int]] = output.map(_.logSegmentBytes)
      def logSegmentDeleteDelayMs: Output[Option[Int]] = output.map(_.logSegmentDeleteDelayMs)
      def maxConnectionsPerIp: Output[Option[Int]] = output.map(_.maxConnectionsPerIp)
      def maxIncrementalFetchSessionCacheSlots: Output[Option[Int]] = output.map(_.maxIncrementalFetchSessionCacheSlots)
      def messageMaxBytes: Output[Option[Int]] = output.map(_.messageMaxBytes)
      def minInsyncReplicas: Output[Option[Int]] = output.map(_.minInsyncReplicas)
      def numPartitions: Output[Option[Int]] = output.map(_.numPartitions)
      def offsetsRetentionMinutes: Output[Option[Int]] = output.map(_.offsetsRetentionMinutes)
      def producerPurgatoryPurgeIntervalRequests: Output[Option[Int]] = output.map(_.producerPurgatoryPurgeIntervalRequests)
      def replicaFetchMaxBytes: Output[Option[Int]] = output.map(_.replicaFetchMaxBytes)
      def replicaFetchResponseMaxBytes: Output[Option[Int]] = output.map(_.replicaFetchResponseMaxBytes)
      def socketRequestMaxBytes: Output[Option[Int]] = output.map(_.socketRequestMaxBytes)
      def transactionRemoveExpiredTransactionCleanupIntervalMs: Output[Option[Int]] = output.map(_.transactionRemoveExpiredTransactionCleanupIntervalMs)
      def transactionStateLogSegmentBytes: Output[Option[Int]] = output.map(_.transactionStateLogSegmentBytes)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafkaUserConfigKafka]])
      def autoCreateTopicsEnable: Output[Option[Boolean]] = output.map(_.flatMap(_.autoCreateTopicsEnable))
      def compressionType: Output[Option[String]] = output.map(_.flatMap(_.compressionType))
      def connectionsMaxIdleMs: Output[Option[Int]] = output.map(_.flatMap(_.connectionsMaxIdleMs))
      def defaultReplicationFactor: Output[Option[Int]] = output.map(_.flatMap(_.defaultReplicationFactor))
      def groupInitialRebalanceDelayMs: Output[Option[Int]] = output.map(_.flatMap(_.groupInitialRebalanceDelayMs))
      def groupMaxSessionTimeoutMs: Output[Option[Int]] = output.map(_.flatMap(_.groupMaxSessionTimeoutMs))
      def groupMinSessionTimeoutMs: Output[Option[Int]] = output.map(_.flatMap(_.groupMinSessionTimeoutMs))
      def logCleanerDeleteRetentionMs: Output[Option[Int]] = output.map(_.flatMap(_.logCleanerDeleteRetentionMs))
      def logCleanerMaxCompactionLagMs: Output[Option[Int]] = output.map(_.flatMap(_.logCleanerMaxCompactionLagMs))
      def logCleanerMinCleanableRatio: Output[Option[Double]] = output.map(_.flatMap(_.logCleanerMinCleanableRatio))
      def logCleanerMinCompactionLagMs: Output[Option[Int]] = output.map(_.flatMap(_.logCleanerMinCompactionLagMs))
      def logCleanupPolicy: Output[Option[String]] = output.map(_.flatMap(_.logCleanupPolicy))
      def logFlushIntervalMessages: Output[Option[Int]] = output.map(_.flatMap(_.logFlushIntervalMessages))
      def logFlushIntervalMs: Output[Option[Int]] = output.map(_.flatMap(_.logFlushIntervalMs))
      def logIndexIntervalBytes: Output[Option[Int]] = output.map(_.flatMap(_.logIndexIntervalBytes))
      def logIndexSizeMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.logIndexSizeMaxBytes))
      def logMessageDownconversionEnable: Output[Option[Boolean]] = output.map(_.flatMap(_.logMessageDownconversionEnable))
      def logMessageTimestampDifferenceMaxMs: Output[Option[Int]] = output.map(_.flatMap(_.logMessageTimestampDifferenceMaxMs))
      def logMessageTimestampType: Output[Option[String]] = output.map(_.flatMap(_.logMessageTimestampType))
      def logPreallocate: Output[Option[Boolean]] = output.map(_.flatMap(_.logPreallocate))
      def logRetentionBytes: Output[Option[Int]] = output.map(_.flatMap(_.logRetentionBytes))
      def logRetentionHours: Output[Option[Int]] = output.map(_.flatMap(_.logRetentionHours))
      def logRetentionMs: Output[Option[Int]] = output.map(_.flatMap(_.logRetentionMs))
      def logRollJitterMs: Output[Option[Int]] = output.map(_.flatMap(_.logRollJitterMs))
      def logRollMs: Output[Option[Int]] = output.map(_.flatMap(_.logRollMs))
      def logSegmentBytes: Output[Option[Int]] = output.map(_.flatMap(_.logSegmentBytes))
      def logSegmentDeleteDelayMs: Output[Option[Int]] = output.map(_.flatMap(_.logSegmentDeleteDelayMs))
      def maxConnectionsPerIp: Output[Option[Int]] = output.map(_.flatMap(_.maxConnectionsPerIp))
      def maxIncrementalFetchSessionCacheSlots: Output[Option[Int]] = output.map(_.flatMap(_.maxIncrementalFetchSessionCacheSlots))
      def messageMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.messageMaxBytes))
      def minInsyncReplicas: Output[Option[Int]] = output.map(_.flatMap(_.minInsyncReplicas))
      def numPartitions: Output[Option[Int]] = output.map(_.flatMap(_.numPartitions))
      def offsetsRetentionMinutes: Output[Option[Int]] = output.map(_.flatMap(_.offsetsRetentionMinutes))
      def producerPurgatoryPurgeIntervalRequests: Output[Option[Int]] = output.map(_.flatMap(_.producerPurgatoryPurgeIntervalRequests))
      def replicaFetchMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.replicaFetchMaxBytes))
      def replicaFetchResponseMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.replicaFetchResponseMaxBytes))
      def socketRequestMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.socketRequestMaxBytes))
      def transactionRemoveExpiredTransactionCleanupIntervalMs: Output[Option[Int]] = output.map(_.flatMap(_.transactionRemoveExpiredTransactionCleanupIntervalMs))
      def transactionStateLogSegmentBytes: Output[Option[Int]] = output.map(_.flatMap(_.transactionStateLogSegmentBytes))


