package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafkaUserConfigKafkaConnectConfig private(
  connectorClientConfigOverridePolicy: Option[String],
  consumerAutoOffsetReset: Option[String],
  consumerFetchMaxBytes: Option[Int],
  consumerIsolationLevel: Option[String],
  consumerMaxPartitionFetchBytes: Option[Int],
  consumerMaxPollIntervalMs: Option[Int],
  consumerMaxPollRecords: Option[Int],
  offsetFlushIntervalMs: Option[Int],
  offsetFlushTimeoutMs: Option[Int],
  producerBatchSize: Option[Int],
  producerBufferMemory: Option[Int],
  producerCompressionType: Option[String],
  producerLingerMs: Option[Int],
  producerMaxRequestSize: Option[Int],
  scheduledRebalanceMaxDelayMs: Option[Int],
  sessionTimeoutMs: Option[Int]
) derives Decoder

object KafkaKafkaUserConfigKafkaConnectConfig:
  given outputOps: {} with
    extension(output: Output[KafkaKafkaUserConfigKafkaConnectConfig])
      def connectorClientConfigOverridePolicy: Output[Option[String]] = output.map(_.connectorClientConfigOverridePolicy)
      def consumerAutoOffsetReset: Output[Option[String]] = output.map(_.consumerAutoOffsetReset)
      def consumerFetchMaxBytes: Output[Option[Int]] = output.map(_.consumerFetchMaxBytes)
      def consumerIsolationLevel: Output[Option[String]] = output.map(_.consumerIsolationLevel)
      def consumerMaxPartitionFetchBytes: Output[Option[Int]] = output.map(_.consumerMaxPartitionFetchBytes)
      def consumerMaxPollIntervalMs: Output[Option[Int]] = output.map(_.consumerMaxPollIntervalMs)
      def consumerMaxPollRecords: Output[Option[Int]] = output.map(_.consumerMaxPollRecords)
      def offsetFlushIntervalMs: Output[Option[Int]] = output.map(_.offsetFlushIntervalMs)
      def offsetFlushTimeoutMs: Output[Option[Int]] = output.map(_.offsetFlushTimeoutMs)
      def producerBatchSize: Output[Option[Int]] = output.map(_.producerBatchSize)
      def producerBufferMemory: Output[Option[Int]] = output.map(_.producerBufferMemory)
      def producerCompressionType: Output[Option[String]] = output.map(_.producerCompressionType)
      def producerLingerMs: Output[Option[Int]] = output.map(_.producerLingerMs)
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.producerMaxRequestSize)
      def scheduledRebalanceMaxDelayMs: Output[Option[Int]] = output.map(_.scheduledRebalanceMaxDelayMs)
      def sessionTimeoutMs: Output[Option[Int]] = output.map(_.sessionTimeoutMs)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafkaUserConfigKafkaConnectConfig]])
      def connectorClientConfigOverridePolicy: Output[Option[String]] = output.map(_.flatMap(_.connectorClientConfigOverridePolicy))
      def consumerAutoOffsetReset: Output[Option[String]] = output.map(_.flatMap(_.consumerAutoOffsetReset))
      def consumerFetchMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.consumerFetchMaxBytes))
      def consumerIsolationLevel: Output[Option[String]] = output.map(_.flatMap(_.consumerIsolationLevel))
      def consumerMaxPartitionFetchBytes: Output[Option[Int]] = output.map(_.flatMap(_.consumerMaxPartitionFetchBytes))
      def consumerMaxPollIntervalMs: Output[Option[Int]] = output.map(_.flatMap(_.consumerMaxPollIntervalMs))
      def consumerMaxPollRecords: Output[Option[Int]] = output.map(_.flatMap(_.consumerMaxPollRecords))
      def offsetFlushIntervalMs: Output[Option[Int]] = output.map(_.flatMap(_.offsetFlushIntervalMs))
      def offsetFlushTimeoutMs: Output[Option[Int]] = output.map(_.flatMap(_.offsetFlushTimeoutMs))
      def producerBatchSize: Output[Option[Int]] = output.map(_.flatMap(_.producerBatchSize))
      def producerBufferMemory: Output[Option[Int]] = output.map(_.flatMap(_.producerBufferMemory))
      def producerCompressionType: Output[Option[String]] = output.map(_.flatMap(_.producerCompressionType))
      def producerLingerMs: Output[Option[Int]] = output.map(_.flatMap(_.producerLingerMs))
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.flatMap(_.producerMaxRequestSize))
      def scheduledRebalanceMaxDelayMs: Output[Option[Int]] = output.map(_.flatMap(_.scheduledRebalanceMaxDelayMs))
      def sessionTimeoutMs: Output[Option[Int]] = output.map(_.flatMap(_.sessionTimeoutMs))


