package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafkaUserConfigPrivateAccess private(
  kafka: Option[Boolean],
  kafkaConnect: Option[Boolean],
  kafkaRest: Option[Boolean],
  prometheus: Option[Boolean],
  schemaRegistry: Option[Boolean]
) derives Decoder

object KafkaKafkaUserConfigPrivateAccess:
  given outputOps: {} with
    extension(output: Output[KafkaKafkaUserConfigPrivateAccess])
      def kafka: Output[Option[Boolean]] = output.map(_.kafka)
      def kafkaConnect: Output[Option[Boolean]] = output.map(_.kafkaConnect)
      def kafkaRest: Output[Option[Boolean]] = output.map(_.kafkaRest)
      def prometheus: Output[Option[Boolean]] = output.map(_.prometheus)
      def schemaRegistry: Output[Option[Boolean]] = output.map(_.schemaRegistry)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafkaUserConfigPrivateAccess]])
      def kafka: Output[Option[Boolean]] = output.map(_.flatMap(_.kafka))
      def kafkaConnect: Output[Option[Boolean]] = output.map(_.flatMap(_.kafkaConnect))
      def kafkaRest: Output[Option[Boolean]] = output.map(_.flatMap(_.kafkaRest))
      def prometheus: Output[Option[Boolean]] = output.map(_.flatMap(_.prometheus))
      def schemaRegistry: Output[Option[Boolean]] = output.map(_.flatMap(_.schemaRegistry))


