package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaKafkaUserConfigSchemaRegistryConfig private(
  leaderEligibility: Option[Boolean],
  topicName: Option[String]
) derives Decoder

object KafkaKafkaUserConfigSchemaRegistryConfig:
  given outputOps: {} with
    extension(output: Output[KafkaKafkaUserConfigSchemaRegistryConfig])
      def leaderEligibility: Output[Option[Boolean]] = output.map(_.leaderEligibility)
      def topicName: Output[Option[String]] = output.map(_.topicName)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaKafkaUserConfigSchemaRegistryConfig]])
      def leaderEligibility: Output[Option[Boolean]] = output.map(_.flatMap(_.leaderEligibility))
      def topicName: Output[Option[String]] = output.map(_.flatMap(_.topicName))


