package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaMirrorMakerServiceIntegration private(
  integrationType: String,
  sourceServiceName: String
) derives Decoder

object KafkaMirrorMakerServiceIntegration:
  given outputOps: {} with
    extension(output: Output[KafkaMirrorMakerServiceIntegration])
      def integrationType: Output[String] = output.map(_.integrationType)
      def sourceServiceName: Output[String] = output.map(_.sourceServiceName)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaMirrorMakerServiceIntegration]])
      def integrationType: Output[Option[String]] = output.map(_.map(_.integrationType))
      def sourceServiceName: Output[Option[String]] = output.map(_.map(_.sourceServiceName))


