package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaServiceIntegration private(
  integrationType: String,
  sourceServiceName: String
) derives Decoder

object KafkaServiceIntegration:
  given outputOps: {} with
    extension(output: Output[KafkaServiceIntegration])
      def integrationType: Output[String] = output.map(_.integrationType)
      def sourceServiceName: Output[String] = output.map(_.sourceServiceName)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaServiceIntegration]])
      def integrationType: Output[Option[String]] = output.map(_.map(_.integrationType))
      def sourceServiceName: Output[Option[String]] = output.map(_.map(_.sourceServiceName))


