package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class KafkaTopicTag private(
  key: String,
  value: Option[String]
) derives Decoder

object KafkaTopicTag:
  given outputOps: {} with
    extension(output: Output[KafkaTopicTag])
      def key: Output[String] = output.map(_.key)
      def value: Output[Option[String]] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[KafkaTopicTag]])
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.flatMap(_.value))


