package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class M3DbM3dbUserConfig private(
  additionalBackupRegions: Option[String],
  customDomain: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  limits: Option[besom.api.aiven.outputs.M3DbM3dbUserConfigLimits],
  m3: Option[besom.api.aiven.outputs.M3DbM3dbUserConfigM3],
  m3Version: Option[String],
  m3coordinatorEnableGraphiteCarbonIngest: Option[Boolean],
  m3dbVersion: Option[String],
  namespaces: Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigNamespace]],
  privateAccess: Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPrivateAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPublicAccess],
  rules: Option[besom.api.aiven.outputs.M3DbM3dbUserConfigRules],
  serviceToForkFrom: Option[String],
  staticIps: Option[Boolean]
) derives Decoder

object M3DbM3dbUserConfig:
  given outputOps: {} with
    extension(output: Output[M3DbM3dbUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def customDomain: Output[Option[String]] = output.map(_.customDomain)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def limits: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigLimits]] = output.map(_.limits)
      def m3: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigM3]] = output.map(_.m3)
      def m3Version: Output[Option[String]] = output.map(_.m3Version)
      def m3coordinatorEnableGraphiteCarbonIngest: Output[Option[Boolean]] = output.map(_.m3coordinatorEnableGraphiteCarbonIngest)
      def m3dbVersion: Output[Option[String]] = output.map(_.m3dbVersion)
      def namespaces: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigNamespace]]] = output.map(_.namespaces)
      def privateAccess: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPublicAccess]] = output.map(_.publicAccess)
      def rules: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigRules]] = output.map(_.rules)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[M3DbM3dbUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def customDomain: Output[Option[String]] = output.map(_.flatMap(_.customDomain))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def limits: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigLimits]] = output.map(_.flatMap(_.limits))
      def m3: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigM3]] = output.map(_.flatMap(_.m3))
      def m3Version: Output[Option[String]] = output.map(_.flatMap(_.m3Version))
      def m3coordinatorEnableGraphiteCarbonIngest: Output[Option[Boolean]] = output.map(_.flatMap(_.m3coordinatorEnableGraphiteCarbonIngest))
      def m3dbVersion: Output[Option[String]] = output.map(_.flatMap(_.m3dbVersion))
      def namespaces: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.M3DbM3dbUserConfigNamespace]]] = output.map(_.flatMap(_.namespaces))
      def privateAccess: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def rules: Output[Option[besom.api.aiven.outputs.M3DbM3dbUserConfigRules]] = output.map(_.flatMap(_.rules))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


