package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class M3DbM3dbUserConfigLimits private(
  maxRecentlyQueriedSeriesBlocks: Option[Int],
  maxRecentlyQueriedSeriesDiskBytesRead: Option[Int],
  maxRecentlyQueriedSeriesLookback: Option[String],
  queryDocs: Option[Int],
  queryRequireExhaustive: Option[Boolean],
  querySeries: Option[Int]
) derives Decoder

object M3DbM3dbUserConfigLimits:
  given outputOps: {} with
    extension(output: Output[M3DbM3dbUserConfigLimits])
      def maxRecentlyQueriedSeriesBlocks: Output[Option[Int]] = output.map(_.maxRecentlyQueriedSeriesBlocks)
      def maxRecentlyQueriedSeriesDiskBytesRead: Output[Option[Int]] = output.map(_.maxRecentlyQueriedSeriesDiskBytesRead)
      def maxRecentlyQueriedSeriesLookback: Output[Option[String]] = output.map(_.maxRecentlyQueriedSeriesLookback)
      def queryDocs: Output[Option[Int]] = output.map(_.queryDocs)
      def queryRequireExhaustive: Output[Option[Boolean]] = output.map(_.queryRequireExhaustive)
      def querySeries: Output[Option[Int]] = output.map(_.querySeries)

  given optionOutputOps: {} with
    extension(output: Output[Option[M3DbM3dbUserConfigLimits]])
      def maxRecentlyQueriedSeriesBlocks: Output[Option[Int]] = output.map(_.flatMap(_.maxRecentlyQueriedSeriesBlocks))
      def maxRecentlyQueriedSeriesDiskBytesRead: Output[Option[Int]] = output.map(_.flatMap(_.maxRecentlyQueriedSeriesDiskBytesRead))
      def maxRecentlyQueriedSeriesLookback: Output[Option[String]] = output.map(_.flatMap(_.maxRecentlyQueriedSeriesLookback))
      def queryDocs: Output[Option[Int]] = output.map(_.flatMap(_.queryDocs))
      def queryRequireExhaustive: Output[Option[Boolean]] = output.map(_.flatMap(_.queryRequireExhaustive))
      def querySeries: Output[Option[Int]] = output.map(_.flatMap(_.querySeries))


