package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class MySqlMysqlUserConfig private(
  additionalBackupRegions: Option[String],
  adminPassword: Option[String],
  adminUsername: Option[String],
  backupHour: Option[Int],
  backupMinute: Option[Int],
  binlogRetentionPeriod: Option[Int],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlMysqlUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  migration: Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMigration],
  mysql: Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMysql],
  mysqlVersion: Option[String],
  privateAccess: Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivateAccess],
  privatelinkAccess: Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivatelinkAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPublicAccess],
  recoveryTargetTime: Option[String],
  serviceToForkFrom: Option[String],
  staticIps: Option[Boolean]
) derives Decoder

object MySqlMysqlUserConfig:
  given outputOps: {} with
    extension(output: Output[MySqlMysqlUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def adminPassword: Output[Option[String]] = output.map(_.adminPassword)
      def adminUsername: Output[Option[String]] = output.map(_.adminUsername)
      def backupHour: Output[Option[Int]] = output.map(_.backupHour)
      def backupMinute: Output[Option[Int]] = output.map(_.backupMinute)
      def binlogRetentionPeriod: Output[Option[Int]] = output.map(_.binlogRetentionPeriod)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlMysqlUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def migration: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMigration]] = output.map(_.migration)
      def mysql: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMysql]] = output.map(_.mysql)
      def mysqlVersion: Output[Option[String]] = output.map(_.mysqlVersion)
      def privateAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPublicAccess]] = output.map(_.publicAccess)
      def recoveryTargetTime: Output[Option[String]] = output.map(_.recoveryTargetTime)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[MySqlMysqlUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def adminPassword: Output[Option[String]] = output.map(_.flatMap(_.adminPassword))
      def adminUsername: Output[Option[String]] = output.map(_.flatMap(_.adminUsername))
      def backupHour: Output[Option[Int]] = output.map(_.flatMap(_.backupHour))
      def backupMinute: Output[Option[Int]] = output.map(_.flatMap(_.backupMinute))
      def binlogRetentionPeriod: Output[Option[Int]] = output.map(_.flatMap(_.binlogRetentionPeriod))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlMysqlUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def migration: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMigration]] = output.map(_.flatMap(_.migration))
      def mysql: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigMysql]] = output.map(_.flatMap(_.mysql))
      def mysqlVersion: Output[Option[String]] = output.map(_.flatMap(_.mysqlVersion))
      def privateAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def recoveryTargetTime: Output[Option[String]] = output.map(_.flatMap(_.recoveryTargetTime))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


