package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class OpenSearchOpensearchUserConfigIndexPattern private(
  maxIndexCount: Int,
  pattern: String,
  sortingAlgorithm: Option[String]
) derives Decoder

object OpenSearchOpensearchUserConfigIndexPattern:
  given outputOps: {} with
    extension(output: Output[OpenSearchOpensearchUserConfigIndexPattern])
      def maxIndexCount: Output[Int] = output.map(_.maxIndexCount)
      def pattern: Output[String] = output.map(_.pattern)
      def sortingAlgorithm: Output[Option[String]] = output.map(_.sortingAlgorithm)

  given optionOutputOps: {} with
    extension(output: Output[Option[OpenSearchOpensearchUserConfigIndexPattern]])
      def maxIndexCount: Output[Option[Int]] = output.map(_.map(_.maxIndexCount))
      def pattern: Output[Option[String]] = output.map(_.map(_.pattern))
      def sortingAlgorithm: Output[Option[String]] = output.map(_.flatMap(_.sortingAlgorithm))


