package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class OpenSearchOpensearchUserConfigOpenid private(
  clientId: String,
  clientSecret: String,
  connectUrl: String,
  enabled: Option[Boolean],
  header: Option[String],
  jwtHeader: Option[String],
  jwtUrlParameter: Option[String],
  refreshRateLimitCount: Option[Int],
  refreshRateLimitTimeWindowMs: Option[Int],
  rolesKey: Option[String],
  scope: Option[String],
  subjectKey: Option[String]
) derives Decoder

object OpenSearchOpensearchUserConfigOpenid:
  given outputOps: {} with
    extension(output: Output[OpenSearchOpensearchUserConfigOpenid])
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def connectUrl: Output[String] = output.map(_.connectUrl)
      def enabled: Output[Option[Boolean]] = output.map(_.enabled)
      def header: Output[Option[String]] = output.map(_.header)
      def jwtHeader: Output[Option[String]] = output.map(_.jwtHeader)
      def jwtUrlParameter: Output[Option[String]] = output.map(_.jwtUrlParameter)
      def refreshRateLimitCount: Output[Option[Int]] = output.map(_.refreshRateLimitCount)
      def refreshRateLimitTimeWindowMs: Output[Option[Int]] = output.map(_.refreshRateLimitTimeWindowMs)
      def rolesKey: Output[Option[String]] = output.map(_.rolesKey)
      def scope: Output[Option[String]] = output.map(_.scope)
      def subjectKey: Output[Option[String]] = output.map(_.subjectKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[OpenSearchOpensearchUserConfigOpenid]])
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def connectUrl: Output[Option[String]] = output.map(_.map(_.connectUrl))
      def enabled: Output[Option[Boolean]] = output.map(_.flatMap(_.enabled))
      def header: Output[Option[String]] = output.map(_.flatMap(_.header))
      def jwtHeader: Output[Option[String]] = output.map(_.flatMap(_.jwtHeader))
      def jwtUrlParameter: Output[Option[String]] = output.map(_.flatMap(_.jwtUrlParameter))
      def refreshRateLimitCount: Output[Option[Int]] = output.map(_.flatMap(_.refreshRateLimitCount))
      def refreshRateLimitTimeWindowMs: Output[Option[Int]] = output.map(_.flatMap(_.refreshRateLimitTimeWindowMs))
      def rolesKey: Output[Option[String]] = output.map(_.flatMap(_.rolesKey))
      def scope: Output[Option[String]] = output.map(_.flatMap(_.scope))
      def subjectKey: Output[Option[String]] = output.map(_.flatMap(_.subjectKey))


