package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class OpenSearchOpensearchUserConfigOpensearchDashboards private(
  enabled: Option[Boolean],
  maxOldSpaceSize: Option[Int],
  opensearchRequestTimeout: Option[Int]
) derives Decoder

object OpenSearchOpensearchUserConfigOpensearchDashboards:
  given outputOps: {} with
    extension(output: Output[OpenSearchOpensearchUserConfigOpensearchDashboards])
      def enabled: Output[Option[Boolean]] = output.map(_.enabled)
      def maxOldSpaceSize: Output[Option[Int]] = output.map(_.maxOldSpaceSize)
      def opensearchRequestTimeout: Output[Option[Int]] = output.map(_.opensearchRequestTimeout)

  given optionOutputOps: {} with
    extension(output: Output[Option[OpenSearchOpensearchUserConfigOpensearchDashboards]])
      def enabled: Output[Option[Boolean]] = output.map(_.flatMap(_.enabled))
      def maxOldSpaceSize: Output[Option[Int]] = output.map(_.flatMap(_.maxOldSpaceSize))
      def opensearchRequestTimeout: Output[Option[Int]] = output.map(_.flatMap(_.opensearchRequestTimeout))


