package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class OpenSearchOpensearchUserConfigPrivatelinkAccess private(
  opensearch: Option[Boolean],
  opensearchDashboards: Option[Boolean],
  prometheus: Option[Boolean]
) derives Decoder

object OpenSearchOpensearchUserConfigPrivatelinkAccess:
  given outputOps: {} with
    extension(output: Output[OpenSearchOpensearchUserConfigPrivatelinkAccess])
      def opensearch: Output[Option[Boolean]] = output.map(_.opensearch)
      def opensearchDashboards: Output[Option[Boolean]] = output.map(_.opensearchDashboards)
      def prometheus: Output[Option[Boolean]] = output.map(_.prometheus)

  given optionOutputOps: {} with
    extension(output: Output[Option[OpenSearchOpensearchUserConfigPrivatelinkAccess]])
      def opensearch: Output[Option[Boolean]] = output.map(_.flatMap(_.opensearch))
      def opensearchDashboards: Output[Option[Boolean]] = output.map(_.flatMap(_.opensearchDashboards))
      def prometheus: Output[Option[Boolean]] = output.map(_.flatMap(_.prometheus))


