package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class OrganizationTimeouts private(
  create: Option[String],
  delete: Option[String],
  read: Option[String],
  update: Option[String]
) derives Decoder

object OrganizationTimeouts:
  given outputOps: {} with
    extension(output: Output[OrganizationTimeouts])
      def create: Output[Option[String]] = output.map(_.create)
      def delete: Output[Option[String]] = output.map(_.delete)
      def read: Output[Option[String]] = output.map(_.read)
      def update: Output[Option[String]] = output.map(_.update)

  given optionOutputOps: {} with
    extension(output: Output[Option[OrganizationTimeouts]])
      def create: Output[Option[String]] = output.map(_.flatMap(_.create))
      def delete: Output[Option[String]] = output.map(_.flatMap(_.delete))
      def read: Output[Option[String]] = output.map(_.flatMap(_.read))
      def update: Output[Option[String]] = output.map(_.flatMap(_.update))


