package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PgComponent private(
  component: Option[String],
  host: Option[String],
  kafkaAuthenticationMethod: Option[String],
  port: Option[Int],
  route: Option[String],
  ssl: Option[Boolean],
  usage: Option[String]
) derives Decoder

object PgComponent:
  given outputOps: {} with
    extension(output: Output[PgComponent])
      def component: Output[Option[String]] = output.map(_.component)
      def host: Output[Option[String]] = output.map(_.host)
      def kafkaAuthenticationMethod: Output[Option[String]] = output.map(_.kafkaAuthenticationMethod)
      def port: Output[Option[Int]] = output.map(_.port)
      def route: Output[Option[String]] = output.map(_.route)
      def ssl: Output[Option[Boolean]] = output.map(_.ssl)
      def usage: Output[Option[String]] = output.map(_.usage)

  given optionOutputOps: {} with
    extension(output: Output[Option[PgComponent]])
      def component: Output[Option[String]] = output.map(_.flatMap(_.component))
      def host: Output[Option[String]] = output.map(_.flatMap(_.host))
      def kafkaAuthenticationMethod: Output[Option[String]] = output.map(_.flatMap(_.kafkaAuthenticationMethod))
      def port: Output[Option[Int]] = output.map(_.flatMap(_.port))
      def route: Output[Option[String]] = output.map(_.flatMap(_.route))
      def ssl: Output[Option[Boolean]] = output.map(_.flatMap(_.ssl))
      def usage: Output[Option[String]] = output.map(_.flatMap(_.usage))


