package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PgPg private(
  dbname: Option[String],
  host: Option[String],
  maxConnections: Option[Int],
  password: Option[String],
  port: Option[Int],
  replicaUri: Option[String],
  sslmode: Option[String],
  uri: Option[String],
  user: Option[String]
) derives Decoder

object PgPg:
  given outputOps: {} with
    extension(output: Output[PgPg])
      def dbname: Output[Option[String]] = output.map(_.dbname)
      def host: Output[Option[String]] = output.map(_.host)
      def maxConnections: Output[Option[Int]] = output.map(_.maxConnections)
      def password: Output[Option[String]] = output.map(_.password)
      def port: Output[Option[Int]] = output.map(_.port)
      def replicaUri: Output[Option[String]] = output.map(_.replicaUri)
      def sslmode: Output[Option[String]] = output.map(_.sslmode)
      def uri: Output[Option[String]] = output.map(_.uri)
      def user: Output[Option[String]] = output.map(_.user)

  given optionOutputOps: {} with
    extension(output: Output[Option[PgPg]])
      def dbname: Output[Option[String]] = output.map(_.flatMap(_.dbname))
      def host: Output[Option[String]] = output.map(_.flatMap(_.host))
      def maxConnections: Output[Option[Int]] = output.map(_.flatMap(_.maxConnections))
      def password: Output[Option[String]] = output.map(_.flatMap(_.password))
      def port: Output[Option[Int]] = output.map(_.flatMap(_.port))
      def replicaUri: Output[Option[String]] = output.map(_.flatMap(_.replicaUri))
      def sslmode: Output[Option[String]] = output.map(_.flatMap(_.sslmode))
      def uri: Output[Option[String]] = output.map(_.flatMap(_.uri))
      def user: Output[Option[String]] = output.map(_.flatMap(_.user))


