package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PgTag private(
  key: String,
  value: String
) derives Decoder

object PgTag:
  given outputOps: {} with
    extension(output: Output[PgTag])
      def key: Output[String] = output.map(_.key)
      def value: Output[String] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[PgTag]])
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.map(_.value))


