package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationDatadogUserConfig private(
  datadogDbmEnabled: Option[Boolean],
  datadogTags: Option[scala.collection.immutable.List[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigDatadogTag]],
  excludeConsumerGroups: Option[scala.collection.immutable.List[String]],
  excludeTopics: Option[scala.collection.immutable.List[String]],
  includeConsumerGroups: Option[scala.collection.immutable.List[String]],
  includeTopics: Option[scala.collection.immutable.List[String]],
  kafkaCustomMetrics: Option[scala.collection.immutable.List[String]],
  maxJmxMetrics: Option[Int],
  opensearch: Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigOpensearch],
  redis: Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigRedis]
) derives Decoder

object ServiceIntegrationDatadogUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationDatadogUserConfig])
      def datadogDbmEnabled: Output[Option[Boolean]] = output.map(_.datadogDbmEnabled)
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigDatadogTag]]] = output.map(_.datadogTags)
      def excludeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.excludeConsumerGroups)
      def excludeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.excludeTopics)
      def includeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.includeConsumerGroups)
      def includeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.includeTopics)
      def kafkaCustomMetrics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.kafkaCustomMetrics)
      def maxJmxMetrics: Output[Option[Int]] = output.map(_.maxJmxMetrics)
      def opensearch: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigOpensearch]] = output.map(_.opensearch)
      def redis: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigRedis]] = output.map(_.redis)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationDatadogUserConfig]])
      def datadogDbmEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.datadogDbmEnabled))
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigDatadogTag]]] = output.map(_.flatMap(_.datadogTags))
      def excludeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.excludeConsumerGroups))
      def excludeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.excludeTopics))
      def includeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.includeConsumerGroups))
      def includeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.includeTopics))
      def kafkaCustomMetrics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.kafkaCustomMetrics))
      def maxJmxMetrics: Output[Option[Int]] = output.map(_.flatMap(_.maxJmxMetrics))
      def opensearch: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigOpensearch]] = output.map(_.flatMap(_.opensearch))
      def redis: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfigRedis]] = output.map(_.flatMap(_.redis))


