package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig private(
  accessKey: String,
  namespace: String,
  region: String,
  secretKey: String
) derives Decoder

object ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig])
      def accessKey: Output[String] = output.map(_.accessKey)
      def namespace: Output[String] = output.map(_.namespace)
      def region: Output[String] = output.map(_.region)
      def secretKey: Output[String] = output.map(_.secretKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig]])
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def namespace: Output[Option[String]] = output.map(_.map(_.namespace))
      def region: Output[Option[String]] = output.map(_.map(_.region))
      def secretKey: Output[Option[String]] = output.map(_.map(_.secretKey))


