package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig private(
  ca: Option[String],
  indexDaysMax: Option[Int],
  indexPrefix: String,
  timeout: Option[Double],
  url: String
) derives Decoder

object ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig])
      def ca: Output[Option[String]] = output.map(_.ca)
      def indexDaysMax: Output[Option[Int]] = output.map(_.indexDaysMax)
      def indexPrefix: Output[String] = output.map(_.indexPrefix)
      def timeout: Output[Option[Double]] = output.map(_.timeout)
      def url: Output[String] = output.map(_.url)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig]])
      def ca: Output[Option[String]] = output.map(_.flatMap(_.ca))
      def indexDaysMax: Output[Option[Int]] = output.map(_.flatMap(_.indexDaysMax))
      def indexPrefix: Output[Option[String]] = output.map(_.map(_.indexPrefix))
      def timeout: Output[Option[Double]] = output.map(_.flatMap(_.timeout))
      def url: Output[Option[String]] = output.map(_.map(_.url))


