package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig private(
  logId: String,
  projectId: String,
  serviceAccountCredentials: String
) derives Decoder

object ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig])
      def logId: Output[String] = output.map(_.logId)
      def projectId: Output[String] = output.map(_.projectId)
      def serviceAccountCredentials: Output[String] = output.map(_.serviceAccountCredentials)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig]])
      def logId: Output[Option[String]] = output.map(_.map(_.logId))
      def projectId: Output[Option[String]] = output.map(_.map(_.projectId))
      def serviceAccountCredentials: Output[Option[String]] = output.map(_.map(_.serviceAccountCredentials))


