package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationEndpointExternalKafkaUserConfig private(
  bootstrapServers: String,
  saslMechanism: Option[String],
  saslPlainPassword: Option[String],
  saslPlainUsername: Option[String],
  securityProtocol: String,
  sslCaCert: Option[String],
  sslClientCert: Option[String],
  sslClientKey: Option[String],
  sslEndpointIdentificationAlgorithm: Option[String]
) derives Decoder

object ServiceIntegrationEndpointExternalKafkaUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpointExternalKafkaUserConfig])
      def bootstrapServers: Output[String] = output.map(_.bootstrapServers)
      def saslMechanism: Output[Option[String]] = output.map(_.saslMechanism)
      def saslPlainPassword: Output[Option[String]] = output.map(_.saslPlainPassword)
      def saslPlainUsername: Output[Option[String]] = output.map(_.saslPlainUsername)
      def securityProtocol: Output[String] = output.map(_.securityProtocol)
      def sslCaCert: Output[Option[String]] = output.map(_.sslCaCert)
      def sslClientCert: Output[Option[String]] = output.map(_.sslClientCert)
      def sslClientKey: Output[Option[String]] = output.map(_.sslClientKey)
      def sslEndpointIdentificationAlgorithm: Output[Option[String]] = output.map(_.sslEndpointIdentificationAlgorithm)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationEndpointExternalKafkaUserConfig]])
      def bootstrapServers: Output[Option[String]] = output.map(_.map(_.bootstrapServers))
      def saslMechanism: Output[Option[String]] = output.map(_.flatMap(_.saslMechanism))
      def saslPlainPassword: Output[Option[String]] = output.map(_.flatMap(_.saslPlainPassword))
      def saslPlainUsername: Output[Option[String]] = output.map(_.flatMap(_.saslPlainUsername))
      def securityProtocol: Output[Option[String]] = output.map(_.map(_.securityProtocol))
      def sslCaCert: Output[Option[String]] = output.map(_.flatMap(_.sslCaCert))
      def sslClientCert: Output[Option[String]] = output.map(_.flatMap(_.sslClientCert))
      def sslClientKey: Output[Option[String]] = output.map(_.flatMap(_.sslClientKey))
      def sslEndpointIdentificationAlgorithm: Output[Option[String]] = output.map(_.flatMap(_.sslEndpointIdentificationAlgorithm))


