package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationEndpointExternalSchemaRegistryUserConfig private(
  authentication: String,
  basicAuthPassword: Option[String],
  basicAuthUsername: Option[String],
  url: String
) derives Decoder

object ServiceIntegrationEndpointExternalSchemaRegistryUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpointExternalSchemaRegistryUserConfig])
      def authentication: Output[String] = output.map(_.authentication)
      def basicAuthPassword: Output[Option[String]] = output.map(_.basicAuthPassword)
      def basicAuthUsername: Output[Option[String]] = output.map(_.basicAuthUsername)
      def url: Output[String] = output.map(_.url)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationEndpointExternalSchemaRegistryUserConfig]])
      def authentication: Output[Option[String]] = output.map(_.map(_.authentication))
      def basicAuthPassword: Output[Option[String]] = output.map(_.flatMap(_.basicAuthPassword))
      def basicAuthUsername: Output[Option[String]] = output.map(_.flatMap(_.basicAuthUsername))
      def url: Output[Option[String]] = output.map(_.map(_.url))


