package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationKafkaConnectUserConfigKafkaConnect private(
  configStorageTopic: Option[String],
  groupId: Option[String],
  offsetStorageTopic: Option[String],
  statusStorageTopic: Option[String]
) derives Decoder

object ServiceIntegrationKafkaConnectUserConfigKafkaConnect:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationKafkaConnectUserConfigKafkaConnect])
      def configStorageTopic: Output[Option[String]] = output.map(_.configStorageTopic)
      def groupId: Output[Option[String]] = output.map(_.groupId)
      def offsetStorageTopic: Output[Option[String]] = output.map(_.offsetStorageTopic)
      def statusStorageTopic: Output[Option[String]] = output.map(_.statusStorageTopic)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationKafkaConnectUserConfigKafkaConnect]])
      def configStorageTopic: Output[Option[String]] = output.map(_.flatMap(_.configStorageTopic))
      def groupId: Output[Option[String]] = output.map(_.flatMap(_.groupId))
      def offsetStorageTopic: Output[Option[String]] = output.map(_.flatMap(_.offsetStorageTopic))
      def statusStorageTopic: Output[Option[String]] = output.map(_.flatMap(_.statusStorageTopic))


