package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationKafkaLogsUserConfig private(
  kafkaTopic: String,
  selectedLogFields: Option[scala.collection.immutable.List[String]]
) derives Decoder

object ServiceIntegrationKafkaLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationKafkaLogsUserConfig])
      def kafkaTopic: Output[String] = output.map(_.kafkaTopic)
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.selectedLogFields)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationKafkaLogsUserConfig]])
      def kafkaTopic: Output[Option[String]] = output.map(_.map(_.kafkaTopic))
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.selectedLogFields))


