package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormaker private(
  consumerFetchMinBytes: Option[Int],
  producerBatchSize: Option[Int],
  producerBufferMemory: Option[Int],
  producerCompressionType: Option[String],
  producerLingerMs: Option[Int],
  producerMaxRequestSize: Option[Int]
) derives Decoder

object ServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormaker:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormaker])
      def consumerFetchMinBytes: Output[Option[Int]] = output.map(_.consumerFetchMinBytes)
      def producerBatchSize: Output[Option[Int]] = output.map(_.producerBatchSize)
      def producerBufferMemory: Output[Option[Int]] = output.map(_.producerBufferMemory)
      def producerCompressionType: Output[Option[String]] = output.map(_.producerCompressionType)
      def producerLingerMs: Output[Option[Int]] = output.map(_.producerLingerMs)
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.producerMaxRequestSize)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormaker]])
      def consumerFetchMinBytes: Output[Option[Int]] = output.map(_.flatMap(_.consumerFetchMinBytes))
      def producerBatchSize: Output[Option[Int]] = output.map(_.flatMap(_.producerBatchSize))
      def producerBufferMemory: Output[Option[Int]] = output.map(_.flatMap(_.producerBufferMemory))
      def producerCompressionType: Output[Option[String]] = output.map(_.flatMap(_.producerCompressionType))
      def producerLingerMs: Output[Option[Int]] = output.map(_.flatMap(_.producerLingerMs))
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.flatMap(_.producerMaxRequestSize))


