package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationLogsUserConfig private(
  elasticsearchIndexDaysMax: Option[Int],
  elasticsearchIndexPrefix: Option[String],
  selectedLogFields: Option[scala.collection.immutable.List[String]]
) derives Decoder

object ServiceIntegrationLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationLogsUserConfig])
      def elasticsearchIndexDaysMax: Output[Option[Int]] = output.map(_.elasticsearchIndexDaysMax)
      def elasticsearchIndexPrefix: Output[Option[String]] = output.map(_.elasticsearchIndexPrefix)
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.selectedLogFields)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationLogsUserConfig]])
      def elasticsearchIndexDaysMax: Output[Option[Int]] = output.map(_.flatMap(_.elasticsearchIndexDaysMax))
      def elasticsearchIndexPrefix: Output[Option[String]] = output.map(_.flatMap(_.elasticsearchIndexPrefix))
      def selectedLogFields: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.selectedLogFields))


