package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ServiceIntegrationMetricsUserConfig private(
  database: Option[String],
  retentionDays: Option[Int],
  roUsername: Option[String],
  sourceMysql: Option[besom.api.aiven.outputs.ServiceIntegrationMetricsUserConfigSourceMysql],
  username: Option[String]
) derives Decoder

object ServiceIntegrationMetricsUserConfig:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationMetricsUserConfig])
      def database: Output[Option[String]] = output.map(_.database)
      def retentionDays: Output[Option[Int]] = output.map(_.retentionDays)
      def roUsername: Output[Option[String]] = output.map(_.roUsername)
      def sourceMysql: Output[Option[besom.api.aiven.outputs.ServiceIntegrationMetricsUserConfigSourceMysql]] = output.map(_.sourceMysql)
      def username: Output[Option[String]] = output.map(_.username)

  given optionOutputOps: {} with
    extension(output: Output[Option[ServiceIntegrationMetricsUserConfig]])
      def database: Output[Option[String]] = output.map(_.flatMap(_.database))
      def retentionDays: Output[Option[Int]] = output.map(_.flatMap(_.retentionDays))
      def roUsername: Output[Option[String]] = output.map(_.flatMap(_.roUsername))
      def sourceMysql: Output[Option[besom.api.aiven.outputs.ServiceIntegrationMetricsUserConfigSourceMysql]] = output.map(_.flatMap(_.sourceMysql))
      def username: Output[Option[String]] = output.map(_.flatMap(_.username))


