package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecActivations private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  network: Output[Option[String]],
  note: Output[Option[String]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  status: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecActivations:
  given outputOps: {} with
    extension(output: Output[AppSecActivations])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def network: Output[Option[String]] = output.flatMap(_.network)
      def note: Output[Option[String]] = output.flatMap(_.note)
      def notificationEmails: Output[scala.collection.immutable.List[String]] = output.flatMap(_.notificationEmails)
      def status: Output[String] = output.flatMap(_.status)
      def version: Output[Int] = output.flatMap(_.version)

def appSecActivations(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecActivationsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecActivations] = 
  ctx.registerResource[AppSecActivations, AppSecActivationsArgs]("akamai:index/appSecActivations:AppSecActivations", name, args, opts)

