package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecActivationsArgs private(
  configId: Output[Int],
  network: Output[Option[String]],
  note: Output[Option[String]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  version: Output[Int]
) derives ArgsEncoder

object AppSecActivationsArgs:
  def apply(
    configId: Input[Int],
    network: Input.Optional[String] = None,
    note: Input.Optional[String] = None,
    notificationEmails: Input[List[Input[String]]],
    version: Input[Int]
  )(using Context): AppSecActivationsArgs =
    new AppSecActivationsArgs(
      configId = configId.asOutput(isSecret = false),
      network = network.asOptionOutput(isSecret = false),
      note = note.asOptionOutput(isSecret = false),
      notificationEmails = notificationEmails.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
