package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecAdvancedSettingsEvasivePathMatch private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  enablePathMatch: Output[Boolean],
  securityPolicyId: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecAdvancedSettingsEvasivePathMatch:
  given outputOps: {} with
    extension(output: Output[AppSecAdvancedSettingsEvasivePathMatch])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def enablePathMatch: Output[Boolean] = output.flatMap(_.enablePathMatch)
      def securityPolicyId: Output[Option[String]] = output.flatMap(_.securityPolicyId)

def appSecAdvancedSettingsEvasivePathMatch(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecAdvancedSettingsEvasivePathMatchArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecAdvancedSettingsEvasivePathMatch] = 
  ctx.registerResource[AppSecAdvancedSettingsEvasivePathMatch, AppSecAdvancedSettingsEvasivePathMatchArgs]("akamai:index/appSecAdvancedSettingsEvasivePathMatch:AppSecAdvancedSettingsEvasivePathMatch", name, args, opts)

