package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecAdvancedSettingsEvasivePathMatchArgs private(
  configId: Output[Int],
  enablePathMatch: Output[Boolean],
  securityPolicyId: Output[Option[String]]
) derives ArgsEncoder

object AppSecAdvancedSettingsEvasivePathMatchArgs:
  def apply(
    configId: Input[Int],
    enablePathMatch: Input[Boolean],
    securityPolicyId: Input.Optional[String] = None
  )(using Context): AppSecAdvancedSettingsEvasivePathMatchArgs =
    new AppSecAdvancedSettingsEvasivePathMatchArgs(
      configId = configId.asOutput(isSecret = false),
      enablePathMatch = enablePathMatch.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOptionOutput(isSecret = false)
    )
