package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecAdvancedSettingsLogging private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  logging: Output[String],
  securityPolicyId: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecAdvancedSettingsLogging:
  given outputOps: {} with
    extension(output: Output[AppSecAdvancedSettingsLogging])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def logging: Output[String] = output.flatMap(_.logging)
      def securityPolicyId: Output[Option[String]] = output.flatMap(_.securityPolicyId)

def appSecAdvancedSettingsLogging(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecAdvancedSettingsLoggingArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecAdvancedSettingsLogging] = 
  ctx.registerResource[AppSecAdvancedSettingsLogging, AppSecAdvancedSettingsLoggingArgs]("akamai:index/appSecAdvancedSettingsLogging:AppSecAdvancedSettingsLogging", name, args, opts)

