package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecAdvancedSettingsLoggingArgs private(
  configId: Output[Int],
  logging: Output[String],
  securityPolicyId: Output[Option[String]]
) derives ArgsEncoder

object AppSecAdvancedSettingsLoggingArgs:
  def apply(
    configId: Input[Int],
    logging: Input[String],
    securityPolicyId: Input.Optional[String] = None
  )(using Context): AppSecAdvancedSettingsLoggingArgs =
    new AppSecAdvancedSettingsLoggingArgs(
      configId = configId.asOutput(isSecret = false),
      logging = logging.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOptionOutput(isSecret = false)
    )
