package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecAdvancedSettingsPragmaHeader private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  pragmaHeader: Output[String],
  securityPolicyId: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecAdvancedSettingsPragmaHeader:
  given outputOps: {} with
    extension(output: Output[AppSecAdvancedSettingsPragmaHeader])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def pragmaHeader: Output[String] = output.flatMap(_.pragmaHeader)
      def securityPolicyId: Output[Option[String]] = output.flatMap(_.securityPolicyId)

def appSecAdvancedSettingsPragmaHeader(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecAdvancedSettingsPragmaHeaderArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecAdvancedSettingsPragmaHeader] = 
  ctx.registerResource[AppSecAdvancedSettingsPragmaHeader, AppSecAdvancedSettingsPragmaHeaderArgs]("akamai:index/appSecAdvancedSettingsPragmaHeader:AppSecAdvancedSettingsPragmaHeader", name, args, opts)

