package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecAdvancedSettingsPragmaHeaderArgs private(
  configId: Output[Int],
  pragmaHeader: Output[String],
  securityPolicyId: Output[Option[String]]
) derives ArgsEncoder

object AppSecAdvancedSettingsPragmaHeaderArgs:
  def apply(
    configId: Input[Int],
    pragmaHeader: Input[String],
    securityPolicyId: Input.Optional[String] = None
  )(using Context): AppSecAdvancedSettingsPragmaHeaderArgs =
    new AppSecAdvancedSettingsPragmaHeaderArgs(
      configId = configId.asOutput(isSecret = false),
      pragmaHeader = pragmaHeader.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOptionOutput(isSecret = false)
    )
